unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    procedure ListView1CustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure ListView1CustomDrawSubItem(Sender: TCustomListView;
      Item: TListItem; SubItem: Integer; State: TCustomDrawState;
      var DefaultDraw: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ListView1CustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  if Odd(Item.Index) then
    Listview1.Canvas.Brush.Color := clAqua
  else
    ListView1.Canvas.Brush.Color := clWhite;
end;

procedure TForm1.ListView1CustomDrawSubItem(Sender: TCustomListView;
  Item: TListItem; SubItem: Integer; State: TCustomDrawState;
  var DefaultDraw: Boolean);
begin
  if Odd(Item.Index) then
    Listview1.Canvas.Brush.Color := clAqua
  else
    ListView1.Canvas.Brush.Color := clWhite;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i,j : Integer;
begin
  for i := 1 to 10 do
    with Listview1.Items.Add do begin
      Caption := 'Item '+ IntToStr(i);
      for j := 1 to 3 do
        Subitems.Add('SubItem '+IntToStr(i)+IntToStr(j));
    end;
end;

end.
